﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdio.h>  // NOLINT(build/include_c_header)
#include "types.h"

//#define DEBUGMSG
//#define STEREO_FORMAT_SUPPORT

enum
{
    SAMPLES_PER_FRAME = 14,
    NIBBLES_PER_FRAME = 16,
    BYTES_PER_FRAME = 8
};

enum
{
    ORDER = 2,
    MAX_LEVEL = 8,
    MAX_SCALE = 12,
    MAX_CLIP = 1
};

enum
{
    MAX_NUM_OF_COEFTABLE = 8,
    NUM_OF_COEFTABLE = 8,
//     NUM_OF_COEFTABLE = 4,
    COEF_SCALING_BIT = 11,
    COEF_SCALING = 2048
};

enum
{
    MAX_CHANNELS = 2
};

/*--------------------------------------------------------------------------*/

typedef struct
{
    u32 length;
    u32 ncoefs;
    u32 srate;
    u8  extension[4];

} NXADPCMHEADER;

/*--------------------------------------------------------------------------*/
/* Nxadpcm.c */
int adpcmReadFileHeader(FILE          *adpcmfile,
                        NXADPCMHEADER *h,
                        s16           *coeftable);
int adpcmWriteFileHeader(FILE          *adpcmfile,
                         NXADPCMHEADER *h,
                         s16           *coeftable);


/* Nxencodeframe.c */
u16  adpcmEncodeFrame(s16 *inbuffer,
                      u8  *outbuffer,
                      s16 *coeftable,
                      u8  step);
#ifdef _M_IX86
u16  adpcmEncodeFrame_SSE(s16 *inbuffer,
                      u8  *outbuffer,
                      s16 *coeftable,
                      u8  step);
#endif
/* Nxdecodeframe.c */
void adpcmDecodeFrame(u8  *aramaddr,
                      s16 *outbuffer,
                      s16 *coeftable,
                      u8  step,
                      u32 loopStart);
