﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "coredump_Format.h"

//==============================================================================
namespace coredump {
//==============================================================================

const char* pHeaderTypeTag              = "DUMP";
const char* pRegisterDefinitionsTypeTag = "RDFS";
const char* pModuleTypeTag              = "MODL";
const char* pThreadTypeTag              = "THRD";
const char* pMemoryTypeTag              = "MMRY";
const char* pCompressedMemoryTypeTag    = "LZ4MRY";
const char* pZLibCompressedMemoryTypeTag= "CMRY";
const char* pTTYTag                     = "TTY ";
const char* pVersionTag                 = "VERSION";
const char* pApplicationIdTag           = "APPID";
const char* pStackFramesTag             = "STCKFRMS";
const char* pBMPImageTag                = "BMPIMAGE";
const char* pRawImageTag                = "RAWIMAGE";
const char* pJPGImageTag                = "JPGIMAGE";
const char* pPNGImageTag                = "PNGIMAGE";
const char* pMP4VideoTag                = "MP4VIDEO";
const char* pRawVideoTag                = "RAWVIDEO";
const char* pThreadLocalStorageTag      = "THREADLS";

//==============================================================================

const char* pRecognizedTags[] =
{
    pHeaderTypeTag,
    pRegisterDefinitionsTypeTag,
    pModuleTypeTag,
    pThreadTypeTag,
    pMemoryTypeTag,
    pCompressedMemoryTypeTag,
    pZLibCompressedMemoryTypeTag,
    pTTYTag,
    pVersionTag,
    pApplicationIdTag,
    pStackFramesTag,
    pBMPImageTag,
    pRawImageTag,
    pJPGImageTag,
    pPNGImageTag,
    pMP4VideoTag,
    pRawVideoTag,
    pThreadLocalStorageTag
};

#define NUMBER_OF_TAGS (sizeof(pRecognizedTags) / sizeof(const char*))

//==============================================================================

bool IsRecognizedTag( coredump_file_data_header* pHdr )
{
    for (int Index = 0; Index < NUMBER_OF_TAGS; Index += 1 )
    {
        if( pHdr->IsTag( pRecognizedTags[Index] ) )
        {
            return true;
        }
    }
    return false;
}

//==============================================================================
} //namespace coredump
//==============================================================================
