﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ovln/ovln_SenderForOverlay.h>

#include "SnapShotDumper.h"
#include "coredump\coredump_Format.h"
#include "coredump\coredump_Data.h"


//============================================================================================

namespace SnapShotDumper
{
    class Output
    {
    public:
        Output( nn::Bit64 ProcessId, nn::svc::Handle ProcessHandle, bool IsQuickDump );
        ~Output();

        nn::svc::Handle GetHandle   ();

        nn::Result SetProcessType   ( nn::svc::DebugEventInfo*          pEventInfo );
        nn::Result SetException     ( nn::svc::DebugEventInfo*          pEventInfo );
        nn::Result CreateThread     ( nn::svc::DebugEventInfo*          pEventInfo );
        nn::Result ExitThread       ( nn::svc::DebugEventInfo*          pEventInfo );

        nn::Result Write            ( char*                             pOutputName );
        nn::Result Log          ( );

    private:
        coredump::coredump_compiled_data m_Data;
        nn::svc::Handle                 m_ProcessHandle;
        nn::svc::DebugInfoCreateProcess m_DebugInfoCreateProcess;

        // To support Siglo-80630 "SSD to send dump progress more frequently"
        nn::ovln::SenderForOverlayType  m_PercentageSender;
        bool                            m_OverlayAvailable;
        float                           m_AmountToWrite;
        float                           m_AmountWritten;
        uint32_t                        m_CurrentPercentComplete;

        //============================================================================
        // Private functionality.
        void        Init                    ( );
        bool        Open                    ( char*                             pOutputName,
                                              coredump::coredump_writer**       pWriter );
        void        AddTTY                  ( coredump::coredump_writer*        pWriter );
        void        AddRegisterDefinitions  ( coredump::coredump_writer*        pWriter );
        void        AddModules              ( coredump::coredump_writer*        pWriter );
        bool        FindModuleName          ( uint64_t                          ModuleAddress,
                                              char*                             pName );
        void        AddMemory               ( coredump::MemoryType              Type,
                                              coredump::u64                     SizeOfData,
                                              coredump::u64                     Address,
                                              coredump::coredump_writer*        pWriter );

        void        AddMemoryBlock          ( nn::svc::MemoryInfo*              pBlockInfo,
                                              coredump::coredump_writer*        pWriter );
        void        AddMemory               ( coredump::coredump_writer*        pWriter );
        void        AddThreads              ( coredump::coredump_writer*        pWriter );
        void        AddThread               ( coredump::coredump_compiled_data_thread* pThread,
                                              coredump::coredump_writer*        pWriter );
        void        AddScreenshot           ( coredump::coredump_writer*        pWriter );
        bool        StartScreenshot         ( size_t                            ScreenshotDataSize,
                                              int                               ScreenshotWidth,
                                              int                               ScreenshotHeight,
                                              coredump::coredump_writer*        pWriter );
        void        FixColors               ( u8*                               pData,
                                              size_t                            DataSize );
        void        AddApplicationID        ( coredump::coredump_writer*        pWriter );

        void        InitializeOverlay       ( );
        void        CalculateWriteAmount    ( );
        void        SendMessage             ( uint32_t                          percent );
        void        OnWrote                 ( size_t                            AmountWritten );
        void        FinalizeOverlay         ( );

        // Logging functionality
        void        AddThreadToLog          ( coredump::coredump_compiled_data_thread* pThread );
        void        AddModulesToLog         ( );
        void        LogStackDump            ( uintptr_t                         StackTop,
                                              uintptr_t                         StackBottom );
        void        LogStackTrace           ( nn::svc::ThreadContext*           pContext );
        void        LogBacktraceItem        ( uintptr_t                         Address,
                                              bool                              ShowDetail );

        nn::dbg::ModuleInfo* GetModules     ( s32*                              pNumberOfModules );
        nn::svc::ThreadContext* GetContext  ( u64                               ThreadId );
    };
};

//============================================================================================
