﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>

#include "SettingsManager_RapidJson.h"

//!< アカウント毎のオンラインストレージ設定の設定名か否かを表す値を返します。
bool IsSettingNameAccountOnlineStorageSettings(
    const ::std::string& value) NN_NOEXCEPT;

//!< アカウント毎のオンラインストレージ設定をエクスポートします。
bool ExportAccountOnlineStorageSettings(Node* pNode) NN_NOEXCEPT;

//!< アカウント毎のオンラインストレージ設定をインポートします。
bool ImportAccountOnlineStorageSettings(const Node& node) NN_NOEXCEPT;
