﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "DevMenuCommand_CommandTypes.h"
#include "DevMenuCommand_CommandBuilder.h"
#include "DevMenuCommand_ValueCommandBuilder.h"
#include "DevMenuCommand_CommandImplUtility.h"

#include <utility>
#include <string>
#include <type_traits>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <cstring>

namespace nn { namespace devmenucommand {

namespace detail {

inline auto MakeValueToStringForApplicationId() NN_NOEXCEPT
{
    return MakeValueToString([](const ncm::ApplicationId& id) -> std::string
    {
        char s[2 + 16 + 1];
        std::sprintf(s, "0x%016llX", static_cast<unsigned long long>(id.value));
        return s;
    });
}

inline auto MakeParserForApplicationId() NN_NOEXCEPT
{
    return MakeParser([](auto* pOut, const std::string& s, const std::string& valueName) -> ProcessResult
    {
        char* pEnd;
        auto value = std::strtoull(s.c_str(), &pEnd, 16);
        if (!(*pEnd == 0))
        {
            return MakeProcessResultFailure(valueName + " must be hex string.");
        }
        *pOut = {value};
        return ProcessResultSuccess;
    });
}

} // detail

inline auto MakeApplicationAttributes()
{
    return std::make_tuple(
        detail::MakeValueToStringForApplicationId(),
        detail::MakeParserForApplicationId(),
        abbreviation::ArgumentString("<applicationId>")
    );
}

namespace abbreviation {

template <typename... Args>
inline auto NcmApplicationId(Args&&... args) NN_NOEXCEPT
{
    return Param<ncm::ApplicationId>(MakeApplicationAttributes(), std::forward<Args>(args)...);
}

}

}}
