﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_InstallTaskBase.h>

inline nn::util::optional<nn::ncm::StorageId> ToStorageId(const std::string& storage)
{
    if (storage == "host") return nn::ncm::StorageId::Host;
    if (storage == "builtin") return nn::ncm::StorageId::BuildInUser;
    if (storage == "sdcard") return nn::ncm::StorageId::SdCard;
    if (storage == "card") return nn::ncm::StorageId::Card;

    return nullptr;
}

inline nn::util::optional<nn::ncm::StorageId> ToInstallStorage(const std::string& storage)
{
    if (storage == "builtin") return nn::ncm::StorageId::BuildInUser;
    if (storage == "sdcard") return nn::ncm::StorageId::SdCard;
    if (storage == "auto") return nn::ncm::StorageId::Any;

    return nullptr;
}

inline nn::util::optional<nn::ncm::StorageId> ToSystemStorage(const std::string& storage)
{
    if (storage == "system") return nn::ncm::StorageId::BuiltInSystem;

    return nullptr;
}

inline const char* ToStringFromStorageId(nn::ncm::StorageId storage) NN_NOEXCEPT
{
    switch (storage)
    {
    case nn::ncm::StorageId::None: return "none";
    case nn::ncm::StorageId::Host: return "host";
    case nn::ncm::StorageId::GameCard: return "card";
    case nn::ncm::StorageId::SdCard: return "sdcard";
    case nn::ncm::StorageId::BuiltInUser: return "builtin";
    default: return "unknown";
    }
}
