﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include "DevMenuCommand_Log.h"
#include "DevMenuCommand_PrintUtil.h"

namespace devmenuUtil {

    void PrintHexDump(const void* pBuffer, size_t size) NN_NOEXCEPT
    {
        if (size == 0)
        {
            return;
        }

        const char* p = reinterpret_cast<const char*>(pBuffer);
        bool isAllZero = true;
        for (size_t i=0; i<size; ++i)
        {
            if (p[i] != 0)
            {
                isAllZero = false;
                break;
            }
        }
        if (isAllZero)
        {
            DEVMENUCOMMAND_LOG("   *** All zero(s)\n");
            return;
        }

        char buf[80];
        const char* hex = "0123456789ABCDEF";
        for (size_t index=0; index<size; index+=16)
        {
            DEVMENUCOMMAND_LOG("   0x%03x: ", index);
            std::strcpy(buf, "                                                :                  ");

            for (size_t i=0; i<16; ++i)
            {
                if (index + i >= size)
                {
                    break;
                }
                auto c = p[index + i];
                buf[i * 3 + 0] = hex[(c >> 4) & 0xf];
                buf[i * 3 + 1] = hex[c & 0xf];
                buf[50 + i + (i >= 8)] = (c >= 0x20 && c < 0x7f) ? c : '.';
            }
            DEVMENUCOMMAND_LOG("%s\n", buf);
        }
    }
}
