﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenuCommand_FirmwareDebugSettings.h"

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>

#include <memory>

namespace nn { namespace devmenucommand {

namespace detail {

ProcessResult GetFirmwareDebugSettingsImpl(void* buffer, size_t bufferSize, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    auto n = settings::fwdbg::GetSettingsItemValue(buffer, bufferSize, category.c_str(), key.c_str());
    if (!(n == bufferSize))
    {
        return {false, "failed to read fwdbg settings (internal error)"};
    }
    return {true, ""};
}

ProcessResult SetFirmwareDebugSettingsImpl(const void* buffer, size_t bufferSize, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    settings::fwdbg::SetSettingsItemValue(category.c_str(), key.c_str(), static_cast<const char*>(buffer), bufferSize);
    return {true, ""};
}

ProcessResult GetFirmwareDebugSettingsImpl(std::string* pOut, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    auto bufferSize = settings::fwdbg::GetSettingsItemValueSize(category.c_str(), key.c_str());
    std::unique_ptr<char[]> p(new char[bufferSize + 1]);
    auto result = GetFirmwareDebugSettingsImpl(p.get(), bufferSize, category.c_str(), key.c_str());
    if (!result.isSuccess)
    {
        return result;
    }
    p[bufferSize] = 0;
    *pOut = p.get();
    return {true, ""};
}

ProcessResult SetFirmwareDebugSettingsImpl(const std::string& data, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return SetFirmwareDebugSettingsImpl(data.c_str(), data.size() + 1, category, key);
}

}

}}
