﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenuCommand_DebugCommandData.h"

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <vector>
#include <memory>
#include "command/DevMenuCommand_Abbreviations.h"

namespace nn { namespace devmenucommand { namespace debug {

const std::vector<SubCommand>& GetDebugSubCommands() NN_NOEXCEPT
{
    // 記述方法は README.md を参照
    using namespace abbreviation;
    static auto g_DebugSubCommands = AggregateSubCommands(std::vector<std::shared_ptr<ICommandBuilder>>
    {
        BoolCommand("movie-recording-debug-mode-enabled", Fwdbg("am.debug/continuous_recording_debug_mode"), NeedsRelaunchApplication),
        BoolCommand("saves-movie-on-exception-enabled", Fwdbg("am.debug/saves_movie_automatically_on_exception"), NeedsRelaunchApplication),
        IntCommand("movie-recording-extra-memory-size", Fwdbg("am.debug/continuous_recording_extra_memory_size"),
            NeedsRelaunchApplication, Hidden, Align(2 * 1024 * 1024), Max(1024 * 1024 * 1024)),
        IntCommand("movie-recording-max-time-on-debug-mode", Fwdbg("am.debug/continuous_recording_max_time_ms_on_debug_mode"),
            NeedsRelaunchApplication, Hidden, ArgumentString("<time_in_milli_seconds>")),
        StringCommand("continuous-recording-extra-memory-target-application-id", Fwdbg("am.debug/continuous_recording_extra_memory_target_application_id"),
            NeedsRelaunchApplication, HiddenPrivate, Hex16),
    });
    return g_DebugSubCommands;
}

}}}
