﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>

namespace nn { namespace wlan {

// エンディアン変換
inline uint16_t ReverseEndian16(uint16_t val) NN_NOEXCEPT
{
    val = static_cast<uint16_t>( ( val & 0x00FF ) << 8 | ( val & 0xFF00 ) >> 8 );
    return val;
}

inline uint32_t ReverseEndian32(uint32_t val) NN_NOEXCEPT
{
    val = static_cast <uint32_t>( ( val & 0x00FF00FF ) << 8 | ( val & 0xFF00FF00 ) >> 8 );
    val = static_cast <uint32_t>( ( val & 0x0000FFFF ) << 16 | ( val & 0xFFFF0000 ) >> 16 );
    return val;
}

}}

