﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/wlan/wlan_Types.h>

namespace nn { namespace wlan {

class SignalStrength
{
private:
    // (SIGLO-41994)通信モード別にリンクレベルしきい値を設定する
    // インフラ2.4GHz用
    static const int32_t RssiThresholdInfra2G1 = -85;
    static const int32_t RssiThresholdInfra2G2 = -72;
    static const int32_t RssiThresholdInfra2G3 = -60;
    // インフラ5GHz用
    static const int32_t RssiThresholdInfra5G1 = -87;
    static const int32_t RssiThresholdInfra5G2 = -75;
    static const int32_t RssiThresholdInfra5G3 = -65;
    // ローカル用
    static const int32_t RssiThresholdLocal1 = -72;
    static const int32_t RssiThresholdLocal2 = -65;
    static const int32_t RssiThresholdLocal3 = -58;

public:
    explicit SignalStrength(int32_t rssi) NN_NOEXCEPT
     : m_Rssi(rssi)
    {
    }

    ~SignalStrength() NN_NOEXCEPT {};

    LinkLevel GetLinkLevelInfra2G() const NN_NOEXCEPT
    {
        if      ( m_Rssi < RssiThresholdInfra2G1 ) return LinkLevel_0;
        else if ( m_Rssi < RssiThresholdInfra2G2 ) return LinkLevel_1;
        else if ( m_Rssi < RssiThresholdInfra2G3 ) return LinkLevel_2;
        else                                       return LinkLevel_3;
    }

    LinkLevel GetLinkLevelInfra5G() const NN_NOEXCEPT
    {
        if      ( m_Rssi < RssiThresholdInfra5G1 ) return LinkLevel_0;
        else if ( m_Rssi < RssiThresholdInfra5G2 ) return LinkLevel_1;
        else if ( m_Rssi < RssiThresholdInfra5G3 ) return LinkLevel_2;
        else                                       return LinkLevel_3;
    }

    LinkLevel GetLinkLevelLocal() const NN_NOEXCEPT
    {
        if      ( m_Rssi < RssiThresholdLocal1 ) return LinkLevel_0;
        else if ( m_Rssi < RssiThresholdLocal2 ) return LinkLevel_1;
        else if ( m_Rssi < RssiThresholdLocal3 ) return LinkLevel_2;
        else                                     return LinkLevel_3;
    }
private:
    int32_t m_Rssi;
};

}}

