﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace wlan {

//static const size_t WlanCommandBufferMax = 16;
//static const size_t WlanEventBufferMax   = 32;
//static const size_t WlanMessageBufferMax = (WlanCommandBufferMax +
//                                            WlanEventBufferMax);

/* StateMachine へ渡すコマンドの構造体 */
struct WlanMessageBuffer {
#if defined (WLANTYPE_DEBUG)
    int                _magicWord;       // Debug用
#endif
    bool               _usingFlag;
    uint32_t           id;               // 要求するコマンド
    void*              Args;             // 引数
    uint32_t           EvnWait;          // コマンド終了待ちの要否
    bool               Result;           // 実行結果(イベント待ちが必要なコマンドはイベントが来てから結果が入れられる) 将来的にはnn::Resultにしたい
    nn::os::EventType  _finishEvent;     // コマンド完了待ちのイベント
    nn::Result         nnResult;
};


typedef WlanMessageBuffer   WlanCommand;
typedef WlanMessageBuffer   WlanEvent;

void InitalWlanMessageStruct(int num_cmdbuff, int num_evnbuff);
void FinalizeWlanMessageStruct();

WlanCommand* GetCommandBuffer(size_t arg_size);
void ReleaseCommandBuffer(WlanCommand* pcmdbuff);

WlanEvent* GetEventBuffer(size_t arg_size);
void ReleaseEventBuffer(WlanEvent* pevebuff);

}}
