﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace wlan {

class IeParser {
public:
    IeParser(uint8_t* IeData, uint16_t Length)
    {
        m_IePointer  = IeData;
        m_Length     = Length;
        m_EndAddress = m_IePointer + m_Length;
    };
    ~IeParser() {};

    void ReadIdAndLen(uint8_t *IeId, uint8_t* Length, uint8_t* ReadPoint)
    {
        /*
         * Information Element format
         * +-----------+------------+--------------------
         * | ID(1Byte) | Len(1Byte) | Payload(n bytes)
         * +-----------+------------+--------------------
         */
        *IeId   = *(ReadPoint + 0);
        *Length = *(ReadPoint + 1);
    }

    uint8_t* GetPayloadAddress(uint8_t* ReadPoint)
    {
        return (ReadPoint + 2);
    }

    uint8_t* SearchIeContinue(int8_t SearchIeId)
    {
        uint8_t* rp = NULL;
        uint8_t ieid;
        uint8_t len = 0;

        while(m_ReadPointer < m_EndAddress)
        {
            ReadIdAndLen(&ieid, &len, m_ReadPointer);

            if(SearchIeId == -1)
            {
                // タグを限定しない場合
                rp = m_ReadPointer;
                ReadPointerFowrding( len );
                break;
            }

            if(ieid == SearchIeId)
            {
                rp = m_ReadPointer;
                ReadPointerFowrding( len );
                break;
            }

            /* Read Pointerは進める */
            ReadPointerFowrding( len );
        }

        return rp;
    };

    uint8_t* SearchIe(int8_t SearchIeId)
    {
        ResetReadPoint();

        return SearchIeContinue( SearchIeId );
    };

    uint8_t* SearchVendorSpecIdWithOuiContinue(uint8_t oui[nn::wlan::MacAddress::OuiSize])
    {
        uint8_t *rp;
        int ret;
        uint8_t len;
        uint8_t id;

        while( 1 )
        {
            rp = SearchIeContinue( 0xdd );
            if(rp == NULL)
            {
                break;
            }

            ReadIdAndLen(&id, &len, rp);
            if(len < 3)
            {
                continue;
            }

            ret = std::memcmp(GetPayloadAddress(rp),
                              static_cast<uint8_t*>(oui),
                              nn::wlan::MacAddress::OuiSize);
            if(ret == 0)
            {
                break;
            }
        }

        return rp;
    }

    uint8_t* SearchVendorSpecIdWithOui(uint8_t oui[nn::wlan::MacAddress::OuiSize])
    {
        ResetReadPoint();
        return SearchVendorSpecIdWithOuiContinue( oui );
    }

    void ResetReadPoint()
    {
        m_ReadPointer = m_IePointer;
    }

private:
    void ReadPointerFowrding(uint8_t len)
    {
        /* IeId(1Byte), Len(1Byte), Payload(len bytes) */
        m_ReadPointer += (1 + 1 + len);
    }

private:
    uint8_t*  m_IePointer;
    uint8_t*  m_ReadPointer;
    uint8_t*  m_EndAddress;
    uint16_t  m_Length;
};


}}
