﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>

#include "wlan_ApiImplBase.h"
#include "../wlan_CommonType.h"
#include "../wlan_StateMachine.h"
#include "../wlan_DebugLog.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan{ namespace server
{
    class DetectApiImpl : public ApiImplBase
    {
    public:
        explicit DetectApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("DetectApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~DetectApiImpl() NN_NOEXCEPT {}

        // ShimレイヤーAPIの実体
        nn::Result OpenMode() NN_NOEXCEPT;
        nn::Result OpenModeWithChannel(std::uint16_t channel) NN_NOEXCEPT;
        nn::Result CloseMode() NN_NOEXCEPT;
        nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result StartPeriodicActionFrame(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t interval) NN_NOEXCEPT;
        nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT;
        nn::Result GetActionFrame(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, nn::sf::Out<std::int64_t> pOutTick) NN_NOEXCEPT;
        nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result ReserveDetectSleep() NN_NOEXCEPT;
        nn::Result CancelDetectSleep() NN_NOEXCEPT;
        nn::Result SetActionFrameForSleep(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result SetHashList(const nn::sf::InBuffer& pHashList) NN_NOEXCEPT;
        nn::Result SetPeriodicActionFrameCycle(const nn::wlan::DetectPeriodicAfCycle& pattern, std::uint8_t target) NN_NOEXCEPT;
        nn::Result RequestSleep() NN_NOEXCEPT;
        nn::Result RequestWakeUp() NN_NOEXCEPT;
        nn::Result PutActionFrameOneShotEx(nn::wlan::detail::SfdlMacAddress macAddr, nn::wlan::detail::SfdlMacAddress bssid, std::uint8_t subtype, const nn::wlan::DetectHeader& dhp, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result StartCommunication() NN_NOEXCEPT;
        nn::Result StopCommunication() NN_NOEXCEPT;
        nn::Result SetMacAddress(nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
        nn::Result GetTotalRecvCountInSleep(nn::sf::Out<std::uint64_t> pOutCount) NN_NOEXCEPT;
        nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT;
    private:
        nn::Result SetDetectRecvConfig(ActionFrameRecvMode mode) NN_NOEXCEPT;
    }; // end of class DetectApiImpl

}}} // end of namespace nn::wlan::server

