﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/htcs.h>

namespace nn{ namespace wlan{ namespace dbg{

static const uint32_t InputBufferSize = 4096;

class WlanHtcs {
private:
    const char* BootMsg = "LocalWL console: You need local echo setting.\r\n";
    const char* ConsoleMsg = "\r\nLWL>";
    const char* CrLf = "\r\n";

public:
    WlanHtcs() NN_NOEXCEPT : m_ConsoleBufferLength(InputBufferSize) {};
    ~WlanHtcs() NN_NOEXCEPT {};

    bool WlanHtcsInit() NN_NOEXCEPT;
    void WlanHtcsMain() NN_NOEXCEPT;
    void CloseConsole() NN_NOEXCEPT;
    int  SendStrings(const char* str, int length) NN_NOEXCEPT;

    virtual void InputCallBack(char* buff, int length) NN_NOEXCEPT = 0;
    virtual void TerminateCallback() NN_NOEXCEPT = 0;

private:
    nn::htcs::SockAddrHtcs m_ServiceAddr;
    int m_ServiceSocket;
    int m_PeerSocket;
    char m_InputBuffer[InputBufferSize];
    uint32_t m_MainLoopAbortFlag;

    uint16_t m_ConsoleBufferLength;

    void ConsoleServerInit() NN_NOEXCEPT;
    bool AcceptWait() NN_NOEXCEPT;
    void ConsoleMain() NN_NOEXCEPT;
    void CloseSocket() NN_NOEXCEPT;
};

}}} // namespace
