﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/ro/ro_DebugMonitorTypes.h>
#include <nn/ro/ro_Result.h>
#include <nn/ro/ro_ResultPrivate.h>
#include <climits>

namespace nn { namespace ro {

    class DebugMonitor
    {
    public:
        static void Initialize() NN_NOEXCEPT;

        nn::Result GetProcessModuleInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<ModuleInfo>& outModules, nn::os::ProcessId id) NN_NOEXCEPT
        {
            if (outModules.GetLength() > INT_MAX)
            {
                return nn::ro::ResultInvalidSize();
            }

            return GetProcessModuleInfo(outCount.GetPointer(), outModules.GetData(), outModules.GetLength(), id);
        }

    private:
        nn::Result GetProcessModuleInfo(int* pOutCount, ModuleInfo* pBuffer, int num, nn::os::ProcessId id) NN_NOEXCEPT;
    };


}}  // namespace nn::ro
