﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/init.h>
#include <nn/os.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "ptm_FanControl.h"
#include "ptm_PsmServer.h"
#include "ptm_TcServer.h"
#include "ptm_ThermalSensor.h"

namespace nn { namespace ptm {

namespace {

void InitializeHipcServer() NN_NOEXCEPT
{
    // Thermal sensor 用サーバの初期化
    nn::ptm::InitializeThermalSensorServer();

    // FanControl 用サーバの初期化
    nn::ptm::InitializeFanControlServer();
    nn::ptm::StartFanControlServer();

    // PSM サーバとドライバライブラリの初期化
    nn::ptm::InitializePsmServer();

    // サーマルコーディネータ初期化
    nn::ptm::InitializeTcServer();
    nn::ptm::StartTcServer();
}

void FinalizeHipcServer() NN_NOEXCEPT
{
    // サーマルコーディネータ終了処理
    nn::ptm::RequestStopTcServer();
    nn::ptm::FinalizeTcServer();

    // PSM サーバとドライバライブラリの終了
    nn::ptm::FinalizePsmServer();

    // FanControl 用サーバの終了処理
    nn::ptm::RequestStopFanControlServer();
    nn::ptm::FinalizeFanControlServer();

    // Thermal sensor 用サーバの終了処理
    nn::ptm::RequestStopThermalSensorServer();
    nn::ptm::FinalizeThermalSensorServer();
}

} // namespace

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(ptm, Main));

    InitializeHipcServer();

    // 終了イベント処理を実装するまでの暫定
    while (1)
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(100000));
    }

    // TORIAEZU:終了はしない
    NN_UNUSED(FinalizeHipcServer);
}

}} // namespace nn::ptm
