﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/psc/server/psc_Server.h>
#include <nn/srepo/service/srepo_Server.h>

namespace nn  {
namespace psc {
namespace     {

const size_t PscMemoryPoolSize = (128 * 1024);
uint8_t      g_PscMemory[PscMemoryPoolSize] NN_ALIGNAS(4096);

} // namespace

}}

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    NN_SDK_ASSERT_EQUAL(NN_SYSTEM_THREAD_PRIORITY(psc, Main), nn::os::GetThreadPriority(nn::os::GetCurrentThread()));
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(psc, Main));

    nn::srepo::service::StartServer();

    nn::Result result = nn::psc::server::Initialize(nn::psc::g_PscMemory, sizeof(nn::psc::g_PscMemory));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    nn::psc::server::Wait();

    nn::srepo::service::StopServer();
}
