﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

NN_PRAGMA_PUSH_WARNINGS
#pragma GCC diagnostic ignored "-Wsign-conversion"
#include <nn/os/os_Tick.h>
NN_PRAGMA_POP_WARNINGS

namespace nn { namespace profiler {

inline uint64_t GetCurrentTime()
{
    // Yes, we could have just called nn::os::GetSystemTick(), but when there is heavy
    // traffic with code blocks, the overhead of just looking up the function in the GOT
    // can become significant.

    uint64_t tick;

#if defined(NN_BUILD_CONFIG_CPU_ARM) && defined(NN_BUILD_CONFIG_CPU_ARM_VE)
    asm volatile ("mrrc p15, 0, %Q0, %R0, c14": "=&r"(tick)::"memory");
#elif defined(NN_BUILD_CONFIG_CPU_ARM64) && defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    asm volatile ("mrs %0, cntpct_el0": "=&r"(tick)::"memory");
#else
#pragma message "No assembly found for config, defaulting to system call."
    tick = static_cast<uint64_t>(nn::os::GetSystemTick().GetInt64Value());
#endif

    return tick;
}

inline uint64_t GetTimeFrequency()
{
    return static_cast<uint64_t>(nn::os::GetSystemTickFrequency());
}

} // profiler
} // nn
