﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include "profiler_SamplingOffset.h"
#include "profiler_Time.h"


namespace nn { namespace profiler {

SamplingOffset::SamplingOffset()
{
    SetBaseValue(0);

    // Should be close enough to random.
    m_randomSeed = static_cast<int32_t>(GetCurrentTime());
}

void SamplingOffset::SetBaseValue(uint32_t baseValue)
{
    uint32_t base = baseValue - MINIMUM_OFFSET;
    m_maxValue = base;
    m_currentOffset = static_cast<int32_t>(base);
}

uint32_t SamplingOffset::GetNextOffset()
{
    return GetOffset();
}

// This algortihm is of the class "Xorshift RNG".
// It produces random 32-bit numbers.
uint32_t SamplingOffset::xor_rand()
{
    uint32_t seed = static_cast<uint32_t>(m_randomSeed);
    uint32_t hold = static_cast<uint32_t>(m_randomSeed);
    seed ^= seed << 13;
    seed ^= seed >> 17;
    seed ^= seed << 5;
    seed += hold;
    m_randomSeed = static_cast<int>(seed);
    return seed;
}

uint32_t SamplingOffset::GetOffset()
{
    //(m_maxValue / 8)
    int32_t bufferOffset = static_cast<int32_t>(m_maxValue >> 3);

    //(m_maxValue - (m_maxValue / 4))
    uint32_t bufferOffsetx2 = static_cast<uint32_t>(bufferOffset << 1);
    int32_t remainderSize = static_cast<int32_t>(m_maxValue - bufferOffsetx2);

    int32_t offsetFromCurrent = static_cast<int>(xor_rand()) % remainderSize;
    offsetFromCurrent = m_currentOffset - offsetFromCurrent;
    if (offsetFromCurrent <= 0)
    {
        offsetFromCurrent += m_maxValue;
    }
    offsetFromCurrent += MINIMUM_OFFSET;

    m_currentOffset = offsetFromCurrent - bufferOffset;
    if (m_currentOffset <= 0)
    {
        m_currentOffset += m_maxValue;
    }
    return static_cast<uint32_t>(offsetFromCurrent);
}

} // profiler
} // nn
