﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/os.h>

#include "ppc_FgmServer.h"
#include "ppc_ApmServer.h"

void* operator new(std::size_t size)
{
    return malloc(size);
}

void* operator new(std::size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    return malloc(size);
}

void  operator delete(void* ptr) NN_NOEXCEPT
{
    free(ptr);
}

void* operator new[](std::size_t size)
{
    return malloc(size);
}

void* operator new[](std::size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    return malloc(size);
}

void  operator delete[](void* ptr) NN_NOEXCEPT
{
    free(ptr);
}

namespace nn  { namespace ppc {

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(ppc, Main));

    InitializeFgmServer();

    InitializeApmServer(true);
    StartApmServer();

    while ( true )
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(100000));
    }

    RequestStopApmServer();
    FinalizeApmServer();

    WaitFgmServer();
}

}} // namespace nn::ppc
