﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/fgm.h>
#include <nn/fgm/server/fgm_Server.h>

namespace nn  {
namespace ppc {
namespace     {

const size_t FgmMemoryPoolSize = (128 * 1024);
uint8_t      g_FgmMemory[FgmMemoryPoolSize] NN_ALIGNAS(4096);

} // namespace

void InitializeFgmServer() NN_NOEXCEPT
{
    nn::Result result;

    result = nn::fgm::server::Initialize(g_FgmMemory, sizeof(g_FgmMemory));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void WaitFgmServer() NN_NOEXCEPT
{
    nn::fgm::server::Wait();
}

}} // namespace nn::ppc
