﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/init.h>
#include <nn/os.h>

#include "npns_Xmpp.h"

namespace nn{ namespace npns{
    // xmpp_stanza_t の参照を管理するクラス
    class Xmpp::Stanza
    {
        //NN_DISALLOW_COPY(Stanza);
        //NN_DISALLOW_MOVE(Stanza);

    public:
        Stanza();
        explicit Stanza(xmpp_ctx_t* pContext, const char* pName);
        explicit Stanza(xmpp_ctx_t* pContext, const char* pName, const char* pNs);
        explicit Stanza(xmpp_ctx_t* pContext);
        explicit Stanza(xmpp_stanza_t* const pRaw);
        Stanza(const Stanza& stanza);
        Stanza& operator=(const Stanza& stanza);

        virtual ~Stanza();

        void SetName(const char* pName);
        void SetType(const char* pType);
        void SetId(const char* pId);
        void SetAttribute(const char* pKey, const char* pValue);
        void SetAttribute(const char* pKey, int32_t value);
        void SetNs(const char* pNs);
        void SetText(const char* pText);
        void AddChild(Stanza& child);
        void AddChildText(const char* pText);

        const char* GetNs() const;
        const char* GetName() const;

        bool GetChildren(Stanza& stanza) const;
        bool GetChildByName(const char* pName, Stanza& stanza) const;
        bool GetNext();
        const char* GetAttribute(const char* pName) const;
        const char* GetType() const;
        bool IsTypeError() const;
        const char* GetId() const;
        bool GetText(Text& text) const;
        bool GetAttributeAsInteger(int64_t* pOut, const char* attribute, int base) const;
        Result Send(xmpp_conn_t * const pConnection);

    protected:
        void HandleError(int error);
        void MergeResult(Result result);
        void Create(xmpp_ctx_t* pContext);
        void Destroy();
        void CloneFrom(xmpp_stanza_t* const pRaw);
        void Dettach();

        xmpp_stanza_t*  m_pStanza;
        Result          m_resultLast;
    };

    class Xmpp::StanzaText : public Xmpp::Stanza
    {
        public:
        StanzaText(xmpp_ctx_t* pContext, const char* pName, const char* pText)
            : Stanza(pContext, pName)
        {
            AddChildText(pText);
        }
    };
}}


