﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <cstdlib>
#include <algorithm>

template<size_t StoreSize = 4096>
class SafeStringBuffer
{
public:
    NN_IMPLICIT SafeStringBuffer(const char* pSource, size_t size)
    {
        Copy(pSource, size);
    }

    NN_IMPLICIT SafeStringBuffer(const nn::sf::InArray<char>& source)
    {
        Copy(source.GetData(), source.GetLength());
    }

    const char* GetString() const
    {
        return m_buffer;
    }
protected:
    void Copy(const char* pBuffer, size_t size)
    {
        size_t copySize = std::min<size_t>(size, StoreSize);
        std::memset(m_buffer, 0, sizeof(m_buffer));
        std::strncpy(m_buffer, pBuffer, copySize);
    }

private:
    char m_buffer[StoreSize + 1];
};




