﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/fs.h>

#include "npns_Common.h"

namespace nn{ namespace npns{

struct PersistentData
{
    static const int CurrentVersion = 1;
    uint32_t version;
    enum CredentialState : uint8_t
    {
        CredentialState_Initial = 0,
        CredentialState_Valid   = 1,
        CredentialState_Invalid = 2
    } state;
    NN_PADDING3;
    Credential credential;
    char environment[4];
};

}}


