﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/npns/npns_Types.h>
#include <nn/os.h>

namespace nn{ namespace npns{

class NotificationQueue
{
public:
    class NotificationHolder : public nn::util::IntrusiveListBaseNode<NotificationHolder>, public NotificationData
    {
    public:
        NN_IMPLICIT NotificationHolder(const NotificationData& nd)
          : NotificationData(nd)
        {
        }
    };

    typedef nn::util::IntrusiveList<NotificationHolder, nn::util::IntrusiveListBaseNodeTraits<NotificationHolder> > NotificationList;

    NN_IMPLICIT NotificationQueue(nn::os::SystemEvent* pEvent);
    ~NotificationQueue();

    Result Send(const NotificationData& nd);
    Result Receive(char* pBuffer, size_t size, uint16_t version);

    void MoveToAll(NotificationQueue& target);
    void MoveToPartial(ApplicationId toId, NotificationQueue& target);

protected:
    bool Push(NotificationHolder* data);
    NotificationHolder* Pop();
    void Notify();

private:
    int m_count;
    static const int MaxCount = 16;
    NotificationList m_list;
    nn::os::SystemEvent* m_pEvent;
};

}}


