﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>
#include "npns_FunctionTracer.h"
#include "npns_Config.h"

#define NN_NPNS_LOG(...)                NN_DETAIL_STRUCTURED_SDK_LOG(npns, Info,  0, ##__VA_ARGS__)
#define NN_NPNS_FATAL(...)              NN_DETAIL_STRUCTURED_SDK_LOG(npns, Fatal, 0, ##__VA_ARGS__)
#define NN_NPNS_ERROR(...)              NN_DETAIL_STRUCTURED_SDK_LOG(npns, Error, 0, ##__VA_ARGS__)
#define NN_NPNS_WARN(...)               NN_DETAIL_STRUCTURED_SDK_LOG(npns, Warn,  0, ##__VA_ARGS__)
#define NN_NPNS_INFO(...)               NN_DETAIL_STRUCTURED_SDK_LOG(npns, Info,  0, ##__VA_ARGS__)

#if NN_NPNS_ENABLE_LOG_VERBOSE
#define NN_NPNS_TRACE(...)              NN_DETAIL_STRUCTURED_SDK_LOG(npns, Trace, 0, ##__VA_ARGS__)
#define NN_NPNS_TRACE_FUNCTION(...)     npns::FunctionTracer tracer(__LINE__, __FILE__, __FUNCTION__, "$npns", diag::LogSeverity_Trace); \
                                        tracer.PrintEntering(__VA_ARGS__);
#else
#define NN_NPNS_TRACE(...)              (void)0
#define NN_NPNS_TRACE_FUNCTION(...)     (void)0
#endif
