﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>

#include "npns_Common.h"
#include "npns_DeferredWorkerThread.h"
#include "npns_HipcServer.h"

namespace nn {
namespace npns {

DeferredWorkerThread::DeferredWorkerThread(IpcServerManager& server)
    : ThreadBase(NN_NPNS_THREAD_CONFIG(DeferredWorker))
    , m_IpcServermanager(server)
{
}

DeferredWorkerThread::~DeferredWorkerThread()
{
    os::MultiWaitHolderType* pHolder; NN_UNUSED(pHolder);
    NN_SDK_ASSERT(!m_TaskQueue.TryGetFront(&pHolder));
    ThreadBase::~ThreadTemplate();
}

Result DeferredWorkerThread::DeferTask(os::MultiWaitHolderType * pHolder)
{
    if (!m_TaskQueue.TrySend(pHolder))
    {
        return ResultSizeLimitExceeded();
    }
    return ResultSuccess();
}

bool DeferredWorkerThread::IsWorkerThreadContext() const
{
    return m_tls.GetValue() != 0;
}

void DeferredWorkerThread::ThreadBody()
{
    m_tls.SetValue(1);
    while (NN_STATIC_CONDITION(true))
    {
        os::MultiWaitHolderType* pHolder;
        pHolder = m_TaskQueue.Receive();
        if (!pHolder)
        {
            break;
        }

        InvokeTask(pHolder);
    }
    NN_SDK_ASSERT(IsExiting());
}

void DeferredWorkerThread::RequestExit()
{
    m_TaskQueue.Send(nullptr);
    ThreadBase::RequestExit();
}

void DeferredWorkerThread::InvokeTask(os::MultiWaitHolderType * pHolder)
{
    m_IpcServermanager.ProcessInvokeRequest(pHolder);
}

Result DeferredWorkerThread::Initialize()
{
    Result result;

    result = ThreadBase::Initialize();
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    return ResultSuccess();
}

void DeferredWorkerThread::Finalize()
{
#if 0
    os::MultiWaitHolderType* pHolder;
    while (m_TaskQueue.TryReceive(&pHolder))
    {

    }
#endif
    ThreadBase::Finalize();
}

}
}

