﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nn {
namespace dmnt {

    struct ThreadData
    {
        int32_t    m_ThreadId;
        nn::Bit64  m_IP;
        nn::Bit64  m_SP;
        nn::Bit32  m_Status;
        nn::Bit32  m_Core;
        nn::Bit32  m_IdealCore;
        nn::Bit32  m_AffinityMask;
        nn::Bit32  m_Priority;
        nn::Bit32  m_PriorityBase;
        nn::Bit32  m_Flags;
        char       m_Name[nn::os::ThreadNameLengthMax];

        nn::svc::ThreadContext m_Context;
    };

} // end of namespace dmnt
} // end of namespace nn
