﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once
#include <nn/btm/detail/btm_Log.h>

//BTM_LOG()の有効化
//#define BTM_ENABLE_LOG

//Busy時間プリントの有効化
//#define BTM_PRINT_BUSY_TIME

//Sniff異常を検出する機能の有効化
#define BTM_CHECK_SNIFF_HISTORY

#ifdef BTM_ENABLE_LOG
#define BTM_LOG(format, ...) NN_DETAIL_BTM_INFO(format, ##__VA_ARGS__)
#else
#define BTM_LOG(...)             static_cast<void>(0)
#endif


namespace nn { namespace btm {

//Utility
void PrintByteDataAsHex(const void* pBuffer, uint16_t length);
int64_t GetCurrentTimeMs();
void CheckSniffHistory();
bool IsSameBdAddress(const BdAddress* pBdAddressAlpha, const BdAddress* pBdAddressBeta);
nn::Result ConvertResult(nn::Result inResult);

}}
