﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/applet/applet_FundamentalTypes.h>

#include <nn/btm/btm_Types.h>
#include <nn/btm/user/btm_UserTypes.h>

namespace nn { namespace btm {


//--------------------------------------------------
//Impl - Worker通信用のType
//--------------------------------------------------
enum ApiId
{
    //Discovery
    ApiId_AcquireDiscoveryEvent,
    ApiId_StartDiscovery,
    ApiId_CancelDiscovery,
    //Pairing
    ApiId_CreateBond,
    ApiId_CancelBond,
    //Connected Device Condition
    ApiId_AcquireDeviceConditionEvent,
    ApiId_SetBurstMode,
    ApiId_SetSlotMode,
    ApiId_SetBluetoothMode,
    ApiId_SetWlanMode,
    //Registered Device Info
    ApiId_AcquireDeviceInfoEvent,
    ApiId_AddDeviceInfo,
    ApiId_RemoveDeviceInfo,
    ApiId_ProtectDeviceInfo,
    ApiId_IncreaseDeviceInfoOrder ,
    //Power Mode
    ApiId_AcquireLlrStateEvent,
    ApiId_LlrNotify,
    ApiId_EnableRadio,
    ApiId_EnableRadio_InMinorSlept,
    ApiId_DisableRadio,
    ApiId_DisableRadio_InMinorSlept,
    ApiId_AcquireAwakeReqEvent,
    ApiId_EnableSlotSaving,
    ApiId_DisableSlotSaving,
    //Test
    ApiId_ChangeTsiMode,
    //Hid
    ApiId_HidConnect,
    ApiId_HidDisconnect,
    ApiId_HidSetRetransmissionMode,
    //System
    ApiId_StartGamepadPairing,
    ApiId_CancelGamepadPairing,
    ApiId_ClearGamepadPairingDatabase,
    ApiId_GetRadioOnOff,
    ApiId_AcquireRadioEvent,
    ApiId_AcquireGamepadPairingEvent,
    ApiId_IsGamepadPairingEnabled,
    //Extension (擬似API用)
    ApiId_ChangeUsecaseByConnect,
    ApiId_ChangeUsecaseByDisconnect,
    ApiId_StoreDeviceInfo,
    ApiId_BlockingCreateBond,
    ApiId_ReStartDiscoveryForAutoPair,
    ApiId_DiscardRadioEvent,
    ApiId_DiscardGamepadPairingEvent,
    ApiId_Recovery,
    // BLE
    //// Scan
    ApiId_AcquireBleScanEvent,                  // 同期
    ApiId_DiscardBleScanEvent,
    ApiId_BleClearScanResult,                   // 同期
    ApiId_BleStartScanGeneral,                  // 同期
    ApiId_BleStopScanGeneral,                   // 同期
    ApiId_BleStartScanPaired,                   // 同期
    ApiId_BleStopScanPaired,                    // 同期
    ApiId_BleStartScanSdGeneral,                // 同期
    ApiId_BleStopScanSdGeneral,                 // 同期
    ApiId_BleRegisterUnconnectableScan,         // 同期
    ApiId_BleUnRegisterUnconnectableScan,       // 同期
    ApiId_BleRegisterSdUnconnectableScan,       // 同期
    ApiId_BleUnRegisterSdUnconnectableScan,     // 同期
    ApiId_BleRegisterWakeOnBle,                 // 同期
    ApiId_BleUnregisterWakeOnBle,               // 同期
    //// Connection
    ApiId_AcquireBleConnectionEvent,            // 同期
    ApiId_DiscardBleConnectionEvent,
    ApiId_BleTryConnect,
    ApiId_BleConnect,                           // 非同期
    ApiId_BleOverrideConnection,
    ApiId_BleDisconnect,                        // 非同期
    ApiId_BleDisconnectNoOwnerConnection,
    ApiId_BleDisconnectAll,                     // 非同期
    ApiId_ChangeUsecaseByBleConnect,
    ApiId_ChangeUsecaseByBleDisconnect,
    //// Pairing
    ApiId_AcquireBlePairingEvent,               // 同期
    ApiId_DiscardBlePairingEvent,
    ApiId_StartBlePairing,
    ApiId_BleEnablePairingErrorHandler,
    ApiId_BlePairingReadAddress,                // 非同期
    ApiId_BlePairingReadAdvData,                // 非同期
    ApiId_BlePairingWriteAddress,               // 非同期
    ApiId_BlePairingWriteComplete,              // 非同期。BLE ペアリングの正常終了を通知
    ApiId_BlePairingWriteAbort,                 // 非同期。BLE ペアリングの中断を通知
    ApiId_BlePairingUpdateDatabase,             // 非同期。BLE ペアリングのデータベースを更新
    //// Service Discovery
    ApiId_AcquireBleSdpEvent,                   // 同期
    ApiId_DiscardBleSdpEvent,
    ApiId_BleGetServices,                       // 同期
    ApiId_BleGetCharacteristics,                // 同期
    ApiId_BleGetDescriptors,                    // 同期
    //// MTU Configuration
    ApiId_AcquireBleMtuConfigEvent,             // 同期
    ApiId_DiscardBleMtuConfigEvent,
    ApiId_BleConfigureMtu,                      // 非同期
    //// Data Path Control
    ApiId_BleRegisterDataPath,                  // 同期
    ApiId_BleUnregisterDataPath,                // 同期
    //Etc
    ApiId_GeneralTest,
    ApiId_End,
};

enum MultiWaitId
{
    MultiWaitId_BtCore,
    MultiWaitId_BtHid,
    MultiWaitId_BtBleCore,
    MultiWaitId_Api,
    MultiWaitId_Psc,
    MultiWaitId_Time,
    MultiWaitId_End,
};

enum UseCase
{
    UseCase_Tera15ms,
    UseCase_Basic5ms,
    UseCase_Basic10ms,
    UseCase_Basic15ms,
    UseCase_BasicTeraOrUpdate15ms,
    UseCase_LocalCommunication15ms,
};


struct CommandParam_SetBluetoothMode
{
    BluetoothMode bluetoothMode;
};

struct CommandParam_SetWlanMode
{
    WlanMode wlanMode;
};

struct CommandParam_CreateBond
{
    BdAddress address;
};

struct CommandParam_CancelBond
{
    BdAddress address;
};

struct CommandParam_SetBurstMode
{
    BdAddress address;
    bool isBurstMode;
};

struct CommandParam_SetSlotMode
{
    DeviceSlotModeList list;
};

struct CommandParam_AddDeviceInfo
{
    DeviceInfo info;
};

struct CommandParam_RemoveDeviceInfo
{
    BdAddress address;
};

struct CommandParam_ProtectDeviceInfo
{
    BdAddress address;
    bool isProtect;
};

struct CommandParam_IncreaseDeviceInfoOrder
{
    BdAddress address;
};

struct CommandParam_LlrNotify
{
    BdAddress address;
};

struct CommandParam_SetTsiMode
{
    BdAddress address;
    TsiMode tsiMode;
};

struct CommandParam_GeneralTest
{
    int mode;
};

struct CommandParam_HidConnect
{
    BdAddress address;
};

struct CommandParam_HidDisconnect
{
    BdAddress address;
};

struct CommandParam_HidSetRetransmissionMode
{
    BdAddress address;
    ZeroRetransmissionList zeroRetransmissionList;
};

struct CommandParam_ChangeUsecaseByConnect
{
    DeviceSlotModeList list;
    bool isRestructureAll;
};

struct CommandParam_ChangeUsecaseByBleConnect
{
    SlotMode defaultSlotMode;
    CeLength defaultCeLength;
};

struct CommandParam_ChangeUsecaseByDisconnect
{
    bool isRestructureAll;
};

struct CommandParam_ChangeUsecaseByBleDisconnect
{
    SlotMode defaultSlotMode;
    CeLength defaultCeLength;
};

struct CommandParam_BlockingCreateBond
{
    BdAddress address;
};

struct CommandParam_DiscardRadioEvent
{
    uint8_t id;
};

struct CommandParam_DiscardGamepadPairingEvent
{
    uint8_t id;
};

struct CommandParam_DiscardBleScanEvent
{
    uint8_t id;
};

struct CommandParam_StartBleScanForGeneral
{
    nn::applet::AppletResourceUserId aruid;
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_StopBleScanForGeneral
{
    nn::applet::AppletResourceUserId aruid;
};

struct CommandParam_StartBleScanForPaired
{
    nn::applet::AppletResourceUserId aruid;
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_StopBleScanForPaired
{
    nn::applet::AppletResourceUserId aruid;
};

struct CommandParam_StartBleScanForSmartDevice
{
    nn::applet::AppletResourceUserId aruid;
    nn::btm::user::BleAdvFilterForSmartDevice condition;
};

struct CommandParam_StopBleScanForSmartDevice
{
    nn::applet::AppletResourceUserId aruid;
};

struct CommandParam_RegisterBleUnconnectableScan
{
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_UnregisterBleUnconnectableScan
{
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_RegisterBleSmartDeviceUnconnectableScan
{
    nn::btm::user::BleAdvFilterForSmartDevice condition;
};

struct CommandParam_UnregisterBleSmartDeviceUnconnectableScan
{
    nn::btm::user::BleAdvFilterForSmartDevice condition;
};

struct CommandParam_RegisterWakeOnBleScan
{
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_UnregisterWakeOnBleScan
{
    nn::btm::user::BleAdvFilterForGeneral condition;
};

struct CommandParam_DiscardBleConnectionEvent
{
    uint8_t id;
};

struct CommandParam_BleConnect
{
    nn::applet::AppletResourceUserId aruid;
    BdAddress address;
};

struct CommandParam_BleOverrideConnection
{
    nn::applet::AppletResourceUserId aruid;
    uint32_t connectionHandle;
};

struct CommandParam_BleDisconnect
{
    uint32_t connectionHandle;
};

struct CommandParam_BleDisconnectNoOwnerConnection
{
    nn::applet::AppletResourceUserId aruid;
};

struct CommandParam_BleDisconnectAll
{
    nn::applet::AppletResourceUserId aruid;
};

struct CommandParam_DiscardBleSdpEvent
{
    uint8_t id;
};

struct CommandParam_BleServiceDiscover
{
    uint32_t connectionHandle;
};

struct CommandParam_DiscardBleMtuConfigEvent
{
    uint8_t id;
};

struct CommandParam_BleConfigureMtu
{
    uint32_t connectionHandle;
    uint16_t mtu;
};

struct CommandParam_DiscardBlePairingEvent
{
    uint8_t id;
};

// Impl で直接触るので、ここに定義
enum BlePairingAdvDataType : uint8_t
{
    BlePairingAdvDataType_Invalid = 0x00,
    BlePairingAdvDataType_ManuCliSerId = 0x01,
};

struct CommandParam_StartBlePairing
{
    uint32_t connectionHandle;
    nn::btm::user::BleAdvFilterForGeneral condition;
    bool pairing;
};

struct CommandParam_BlePairingUpdateDatabase
{
    BdAddress                               address;
    BlePairingAdvDataType                   type;
    nn::btm::user::BleAdvFilterForGeneral   condition;
    bool                                    pairing;
};

struct CommandParam_BleRegisterDataPath
{
    nn::bluetooth::GattAttributeUuid    uuid;
    user::BleDataPathType               path;
};

struct CommandParam_BleUnregisterDataPath
{
    nn::bluetooth::GattAttributeUuid    uuid;
    user::BleDataPathType               path;
};

struct ReportParam_AcquireDiscoveryEvent
{
    nn::os::NativeHandle handle;
};

struct ReportParam_GetDiscoveredDevices
{
    DevicePropertyList list;
};

struct ReportParam_AcquireDeviceConditionEvent
{
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireDeviceInfoEvent
{
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireLlrStateEvent
{
    nn::os::NativeHandle handle;
};

struct ReportParam_GetConnectedDeviceCondition
{
    DeviceConditionList list;
};

struct ReportParam_AcquireAwakeReqEvent
{
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireRadioEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireGamepadPairingEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_IsGamepadPairingEnabled
{
    bool isEnabled;
};

struct ReportParam_AcquireBleScanEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_BleScanState
{
    uint8_t scanState;
};

struct ReportParam_AcquireBleConnectionEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_BleConnect
{
    uint32_t    connectionHandle;
    BdAddress   address;
};

struct ReportParam_BleDisconnect
{
    uint32_t    connectionHandle;
    BdAddress   address;
};

struct ReportParam_AcquireBlePairingEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireBleSdpEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_AcquireBleMtuConfigEvent
{
    uint8_t id;
    nn::os::NativeHandle handle;
};

struct ReportParam_BleMtu
{
    uint32_t connectionHandle;
    uint16_t mtu;
};

}}
