﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ApiPrivate.h>
#include <nn/fs/fs_MemoryManagement.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/pm/pm_ShellApi.h>

#include "boot2_Boot.h"
#include "boot2_SigloBoot.h"

using namespace nn;

namespace
{
    char  g_FilesystemAllocatorHeap[64 * 1024];
    nn::mem::StandardAllocator g_FilesystemAllocator(g_FilesystemAllocatorHeap, sizeof(g_FilesystemAllocatorHeap));
    void* AllocateForFilesystem(size_t size)
    {
        return g_FilesystemAllocator.Allocate(size);
    }
    void DeallocateForFileSystem(void* p, size_t size)
    {
        NN_UNUSED(size);
        return g_FilesystemAllocator.Free(p);
    }
}

extern "C" void nninitStartup() NN_NOEXCEPT
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain() NN_NOEXCEPT
{
    fs::InitializeWithMultiSessionForSystem();
    fs::SetAllocator(AllocateForFilesystem, DeallocateForFileSystem);

    pm::InitializeForShell();

    boot2::LaunchBootPrograms();

#ifdef NN_SIGLO_BOOT_USE_PROCESS_LIST
    boot2::SigloBoot();
#endif
}

void* operator new(size_t size)
{
    return g_FilesystemAllocator.Allocate(size);
}

void operator delete(void* p) NN_NOEXCEPT
{
    return g_FilesystemAllocator.Free(p);
}
