﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/dd.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_TimeSpan.h>

#include <t21x/arapb_misc.h>
#include <t21x/arapbpm.h>
#include <t21x/arclk_rst.h>
#include <t21x/ardsi.h>
#include "reg.h"

namespace nn { namespace boot {

    namespace
    {
        uintptr_t   NN_BLSM_REG_GPIO;

        bool IsVolumeUpPressed()
        {
            return ((nn::reg::Read(NN_BLSM_REG_GPIO + 0x53C) >> 6) & 0x1) == 0;
        }

        bool IsVolumeDownPressed()
        {
            return ((nn::reg::Read(NN_BLSM_REG_GPIO + 0x53C) >> 7) & 0x1) == 0;
        }
    }

    bool IsAnyVolumeButtonPressed() NN_NOEXCEPT
    {
        NN_BLSM_REG_GPIO        = dd::QueryIoMappingAddress(0x6000D000,  0x1000);

        if (IsVolumeUpPressed() || IsVolumeDownPressed())
        {
            return true;
        }
        return false;
    }

}} // namespace nn::boot
