﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/gpio/driver/gpio.h>
#include <nn/gpio/driver/gpio_PadAccessorDev.h>

#include "boot_SplAccessor.h"

namespace nn { namespace boot {

void SetFanPowerEnabled() NN_NOEXCEPT
{
    auto hardwareType = nn::boot::GetHardwareType();
    if (hardwareType == nn::spl::HardwareType_Copper)
    {
        nn::gpio::driver::GpioPadSession session;

        // TORIAEZU : Initialize() を呼ぶと割り込み用のスレッドを回してしまうので呼ばない
        // ドライバの動作には影響はない
        //nn::gpio::driver::Initialize();
        nn::gpio::driver::OpenSession(&session, nn::gpio::GpioPadName_FanEn);
        nn::gpio::driver::SetDirection(&session, nn::gpio::Direction_Output);
        nn::gpio::driver::SetValue(&session, nn::gpio::GpioValue_High);
        nn::gpio::driver::CloseSession(&session);
        //nn::gpio::driver::Finalize();
    }
    else
    {
        // Icosa はここで Fan を enable にはしない
    }
}

}}  // namespace nn::boot
