﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_ADDRESS_64
extern nn::Bit8 NN_BOOT_COLD_BOOT_BIN_begin[];
extern nn::Bit8 NN_BOOT_COLD_BOOT_BIN_end[];
extern nn::Bit8 NN_BOOT_CHARGING_BIN_begin[];
extern nn::Bit8 NN_BOOT_CHARGING_BIN_end[];
extern nn::Bit8 NN_BOOT_CHARGING_RED_BIN_begin[];
extern nn::Bit8 NN_BOOT_CHARGING_RED_BIN_end[];
extern nn::Bit8 NN_BOOT_LOW_BATTERY_BIN_begin[];
extern nn::Bit8 NN_BOOT_LOW_BATTERY_BIN_end[];
#if defined NN_BOOT_BUILD_TYPE_DEV_UPDATER
extern nn::Bit8 NN_BOOT_DEV_UPDATER_BIN_begin[];
extern nn::Bit8 NN_BOOT_DEV_UPDATER_BIN_end[];
#endif
// extern nn::Bit8 NN_BOOT_STARTUP_LOGO_BIN_begin[];
// extern nn::Bit8 NN_BOOT_STARTUP_LOGO_BIN_end[];
#else
const nn::Bit8* const NN_BOOT_COLD_BOOT_BIN_begin = nullptr;
const nn::Bit8* const NN_BOOT_COLD_BOOT_BIN_end = nullptr;
const nn::Bit8* const NN_BOOT_CHARGING_BIN_begin = nullptr;
const nn::Bit8* const NN_BOOT_CHARGING_BIN_end = nullptr;
const nn::Bit8* const NN_BOOT_CHARGING_RED_BIN_begin = nullptr;
const nn::Bit8* const NN_BOOT_CHARGING_RED_BIN_end = nullptr;
const nn::Bit8* const NN_BOOT_LOW_BATTERY_BIN_begin = nullptr;
const nn::Bit8* const NN_BOOT_LOW_BATTERY_BIN_end = nullptr;
#if defined NN_BOOT_BUILD_TYPE_DEV_UPDATER
const nn::Bit8* const NN_BOOT_DEV_UPDATER_BIN_begin = nullptr;
const nn::Bit8* const NN_BOOT_DEV_UPDATER_BIN_end = nullptr;
#endif
// const nn::Bit8* const NN_BOOT_STARTUP_LOGO_BIN_begin = nullptr;
// const nn::Bit8* const NN_BOOT_STARTUP_LOGO_BIN_end = nullptr;
#endif

namespace nn { namespace boot {
    const Bit8* const ColdBootData = NN_BOOT_COLD_BOOT_BIN_begin;
    const size_t ColdBootDataSize = static_cast<size_t>(NN_BOOT_COLD_BOOT_BIN_end - NN_BOOT_COLD_BOOT_BIN_begin);
    const int ColdBootWidth = 324;
    const int ColdBootHeight = 80;
    const int ColdBootPointX = 1280 / 2 - ColdBootWidth / 2;
    const int ColdBootPointY = 720 / 2 - ColdBootHeight / 2;

    const Bit8* const ChargingData = NN_BOOT_CHARGING_BIN_begin;
    const size_t ChargingDataSize = static_cast<size_t>(NN_BOOT_CHARGING_BIN_end - NN_BOOT_CHARGING_BIN_begin);
    const int ChargingPointX = 26;
    const int ChargingPointY = 28;
    const int ChargingWidth = 76;
    const int ChargingHeight = 28;

    const Bit8* const ChargingRedData = NN_BOOT_CHARGING_RED_BIN_begin;
    const size_t ChargingRedDataSize = static_cast<size_t>(NN_BOOT_CHARGING_RED_BIN_end - NN_BOOT_CHARGING_RED_BIN_begin);
    const int ChargingRedPointX = 26;
    const int ChargingRedPointY = 28;
    const int ChargingRedWidth = 76;
    const int ChargingRedHeight = 28;

    const Bit8* const LowBatteryData = NN_BOOT_LOW_BATTERY_BIN_begin;
    const size_t LowBatteryDataSize = static_cast<size_t>(NN_BOOT_LOW_BATTERY_BIN_end - NN_BOOT_LOW_BATTERY_BIN_begin);
    const int LowBatteryPointX = 26;
    const int LowBatteryPointY = 28;
    const int LowBatteryWidth = 52;
    const int LowBatteryHeight = 28;

#if defined NN_BOOT_BUILD_TYPE_DEV_UPDATER
    const Bit8* const DevUpdaterData = NN_BOOT_DEV_UPDATER_BIN_begin;
    const size_t DevUpdaterDataSize = static_cast<size_t>(NN_BOOT_DEV_UPDATER_BIN_end - NN_BOOT_DEV_UPDATER_BIN_begin);
    const int DevUpdaterWidth = 347;
    const int DevUpdaterHeight = 55;
    const int DevUpdaterPointX = 1280 / 2 - DevUpdaterWidth / 2;
    const int DevUpdaterPointY = 720 / 2 - DevUpdaterHeight / 2;
#endif

#if 0
    const Bit8* const StartupLogoData = NN_BOOT_STARTUP_LOGO_BIN_begin;
    const size_t StartupLogoDataSize = static_cast<size_t>(NN_BOOT_STARTUP_LOGO_BIN_end - NN_BOOT_STARTUP_LOGO_BIN_begin);
    const int StartupLogoWidth = 360;
    const int StartupLogoHeight = 90;
    const int StartupLogoPointX = 1280 / 2 - StartupLogoWidth / 2;
    const int StartupLogoPointY = 720 / 2 - StartupLogoHeight / 2;
#endif
}}
