﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/spl/spl_Types.h>
#include <nn/updater/updater.h>

#include "boot_BatteryChargeChecker.h"
#include "boot_BootImage.h"

namespace nn { namespace boot {

namespace {

NN_ALIGNAS(4096) uint8_t BootImageUpdateBuffer[64 << 10];

}

void RepairBootImagesAndRebootIfNeeded(nn::spl::HardwareType hardwareType) NN_NOEXCEPT
{
#if defined(NN_BOOT_BUILD_TYPE_SAFE_MODE)
    NN_UNUSED(hardwareType);
    NN_UNUSED(BootImageUpdateBuffer);
#else
    auto bootImageUpdateType = nn::updater::GetBootImageUpdateType(hardwareType);

    bool normalUpdated, safeUpdated;
    auto result = nn::updater::VerifyBootImagesAndUpdateIfNeeded(&normalUpdated, &safeUpdated, BootImageUpdateBuffer, sizeof(BootImageUpdateBuffer), bootImageUpdateType);
    if (result.IsSuccess())
    {
        if (normalUpdated)
        {
            NN_SDK_LOG("[boot] BootImages are updated\n");
            nn::boot::RebootSystem();
        }
        if (safeUpdated)
        {
            NN_SDK_LOG("[boot] BootImagesSafe are updated\n");
        }
    }
    else
    {
        NN_SDK_LOG("[boot] Verify BootImages failed: %08x\n", result.GetInnerValueForDebug());
    }
#endif
}

}} // namespace nn::boot
