﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "bluetooth_InternalTypes.h"



#ifdef __cplusplus

namespace nn {
namespace bluetooth {

/**
 * @brief Represents the standard Bluetooth interface.
 */
class BluetoothExtC
{
    NN_DISALLOW_COPY(BluetoothExtC);
    NN_DISALLOW_MOVE(BluetoothExtC);

public:
    BluetoothExtC() NN_NOEXCEPT : m_BluetoothExt() {}

    BluetoothExtension& GetBluetoothExtension() NN_NOEXCEPT
    {
        return m_BluetoothExt;
    };

     /* Register the BtExt callbacks */
    static BluetoothHhStatus InitializeExtension(BluetoothExtCallbacks* callbacks);

    /* TSI api */
    static BluetoothHhStatus HalIfSetTSI(Btbdaddr *pBdAddr, uint8_t tsi_mode);

    /* Exit TSI api */
    static BluetoothHhStatus HalIfExitTSI(Btbdaddr *pBdAddr);

    /* Burst mode api */
    static BluetoothHhStatus HalIfSetBurstMode(Btbdaddr *pBdAddr);

    /* Exit Burst mode api */
    static BluetoothHhStatus HalIfExitBurstMode(Btbdaddr *pBdAddr);

    /* set static AFH */
    static BluetoothHhStatus HalIfSetSfh(uint8_t sfh_on, uint8_t *pChannels,uint32_t length, uint32_t sfh_offset);

    /* 0-re-transmission api */
    static BluetoothHhStatus HalIfSetZeroRetran(Btbdaddr *pBdAddr, uint8_t numIds, const uint8_t *pIds);

    /* set MC mode api */
    static BluetoothHhStatus HalIfSetMcMode(bool isMcModeEnabled);

    /* start llr mode */
    static BluetoothHhStatus HalIfStartLlrMode();

    /* exit llr mode */
    static BluetoothHhStatus HalIfExitLlrMode();

    /* set radio on/off */
    static BluetoothHhStatus HalIfSetRadio(bool enable);

    /* set radio discoverable/connectable */
    static BluetoothHhStatus HalIfSetVisibility(bool discoverable, bool connectable);

    /* set TBFC scan on/off */
    static BluetoothHhStatus HalIfSetTbfcScan(bool enable);

    /* get number of pending connections */
    static BluetoothHhStatus HalIfGetPendingConnections();

private:
    BluetoothExtension m_BluetoothExt;
};

} // bluetooth
} // nn

#endif
