﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gpio/gpio.h>
#include "bluetooth.h"


#if (defined(NN_BUILD_CONFIG_SPEC_NX))
static void InitializeGpioOutput(nn::gpio::GpioPadName pad, bool power)
{
    nn::gpio::GpioPadSession session;
    nn::gpio::Initialize();
    nn::gpio::OpenSession(&session, pad);
    nn::gpio::SetDirection(&session, nn::gpio::Direction_Output);
    nn::gpio::SetValue(&session, power ? nn::gpio::GpioValue_High : nn::gpio::GpioValue_Low);
    nn::gpio::CloseSession(&session);
    nn::gpio::Finalize();
}
#endif


void bluetoothGpioPowerEnable(bool power)
{
#if (defined(NN_BUILD_CONFIG_SPEC_NX))
    InitializeGpioOutput(nn::gpio::GpioPadName_BtRst, power);
#endif
}

extern "C" void bluetoothGpioApWakeBtEnable(bool enable)
{
#if (defined(NN_BUILD_CONFIG_SPEC_NX))
    InitializeGpioOutput(nn::gpio::GpioPadName_ApWakeBt, enable);
#endif
}
