﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_ServiceResource.h>
#include <nn/account/account_RuntimeResource.h>
#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>

namespace nn {

/* 動作させるアカウントサービスのコンフィギュレーションを決定する。 ----------------------------------------------*/
typedef account::DefaultServiceResource AccountResourceType;

/* サービススレッドの資源 ----------------------------------------------------------------------------*/
static const int AccountSessionCountMax = 64;
static const int AccountPortCountMax = 4;
struct AccountServerOption
{
    static const bool CanDeferInvokeRequest = false;
    static const int ObjectInSubDomainCountMax = 16 * 128;
    static const size_t PointerTransferBufferSize = 2 * 4096;
    static const int SubDomainCountMax = 32;
};
enum AccountServerPort
{
    AccountServerPort_Administrators = 100,
    AccountServerPort_SystemServices = 101,
    AccountServerPort_Applications = 102,
    AccountServerPort_BaasAccessTokenAccessors = 200,
};
class AccountServer
    : public sf::HipcSimpleAllInOneServerManager<AccountSessionCountMax, AccountPortCountMax, AccountServerOption>
{
private:
    typedef sf::HipcSimpleAllInOneServerManager<AccountSessionCountMax, AccountPortCountMax, AccountServerOption> Server;

    AccountResourceType& m_Resource;

protected:
    Result OnNeedsToAccept(int portIndex, Server::AcceptTarget* pPort) NN_NOEXCEPT NN_OVERRIDE final
    {
        switch (portIndex)
        {
        case AccountServerPort_Administrators:
            return Server::AcceptImpl(
                pPort,
                m_Resource.GetServicePointer<account::IAccountServiceForAdministrator>());

        case AccountServerPort_SystemServices:
            return Server::AcceptImpl(
                pPort,
                m_Resource.GetServicePointer<account::IAccountServiceForSystemService>());

        case AccountServerPort_Applications:
            return Server::AcceptImpl(
                pPort,
                m_Resource.CreateServiceObjectForApplication());

        case AccountServerPort_BaasAccessTokenAccessors:
            return Server::AcceptImpl(
                pPort,
                m_Resource.GetBaasAccessTokenAccessorPointer());

        default:
            NN_UNEXPECTED_DEFAULT;
        }
    }

public:
    explicit AccountServer(AccountResourceType& resource) NN_NOEXCEPT
        : m_Resource(resource)
    {
    }
};
const size_t AccoutServerThreadStackSize = 4 * 4096;

/* Executorスレッドの資源 ----------------------------------------------------------------------------*/
const size_t AccountExecThreadStackSize = 4 * 4096;
const size_t AccountExecThreadBufferSize = account::RequiredBufferSize;

// サーバーの開始と終了
Result StartAccountServer(AccountResourceType& resource) NN_NOEXCEPT;
void StopAccountServer() NN_NOEXCEPT;

} // ~namespace nn
