﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>

#define GDBSERVER_TRACING

#ifdef GDBSERVER_TRACING
#define GDB_TRACE_S(FORMAT_STRING, ...) NN_SDK_LOG("GDBE: " FORMAT_STRING , ## __VA_ARGS__)     //  S - Session state
//#define GDB_TRACE_N(FORMAT_STRING, ...) NN_SDK_LOG("GDBN: " FORMAT_STRING , ## __VA_ARGS__)   //  N - gdbserver network protocol
//#define GDB_TRACE_P(FORMAT_STRING, ...) NN_SDK_LOG("GDBP: " FORMAT_STRING , ## __VA_ARGS__)   //  P - gdbserver packets
//#define GDB_TRACE_T(FORMAT_STRING, ...) NN_SDK_LOG("GDBT: " FORMAT_STRING , ## __VA_ARGS__)   //  T - gdbserver tracing
#define GDB_TRACE_E(FORMAT_STRING, ...) NN_SDK_LOG("GDBE: " FORMAT_STRING , ## __VA_ARGS__)     //  E - errors
#define GDB_TRACE_W(FORMAT_STRING, ...) NN_SDK_LOG("GDBW: " FORMAT_STRING , ## __VA_ARGS__)     //  W - warnings
#endif

#ifndef GDB_TRACE_S
#define GDB_TRACE_S(...) static_cast<void>(0)
#endif

#ifndef GDB_TRACE_N
#define GDB_TRACE_N(...) static_cast<void>(0)
#endif

#ifndef GDB_TRACE_P
#define GDB_TRACE_P(...) static_cast<void>(0)
#endif

#ifndef GDB_TRACE_T
#define GDB_TRACE_T(...) static_cast<void>(0)
#endif

#ifndef GDB_TRACE_E
#define GDB_TRACE_E(...) static_cast<void>(0)
#endif

#ifndef GDB_TRACE_W
#define GDB_TRACE_W(...) static_cast<void>(0)
#endif


