﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Synchronization.h>

namespace nn { namespace dmnt { namespace gdbserver {
void Initialize();
Result DebugNewProcess(char* fileName, int port);
void AttachProcess(nn::svc::Handle* pOut, Bit64 processId, int port);
void AttachProcess(nn::svc::Handle* pOut, nn::svc::Handle handle, int port, const char* name);
void TerminateProcess(Bit64 processId);
}}}

