﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "BreakPointManager.h"

namespace nn { namespace dmnt {

struct SoftBreakPoint : public BreakPoint
{
    uint32_t m_OriginalData;

    virtual nn::Result Set(DebugProcess *debugProcess, uintptr_t addr, size_t len, bool isStep);
    virtual nn::Result Clear(DebugProcess *debugProcess);
};

class SoftwareBreakPoints : public BreakPointManager
{
public:
    explicit SoftwareBreakPoints(DebugProcess *debugProcess);
    static const int NUM_BREAKPOINT = 128;

private:
    SoftBreakPoint m_BreakPoints[NUM_BREAKPOINT];
    virtual BreakPoint *GetBreakPoint(unsigned index);
};

}}

