﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace dmnt {

class DebugProcess;

struct BreakPointBase
{
    bool m_InUse;
    uintptr_t m_Addr;
    size_t m_Length;

    BreakPointBase()
    : m_InUse(false)
    {
    }

    void Reset()
    {
        m_InUse = false;
    }
    virtual nn::Result Clear(DebugProcess *debugProcess) = 0;
};

class BreakPointManagerBase
{
public:
    explicit BreakPointManagerBase(DebugProcess *debugProcess);
    Result Initialize();

    void ClearAll();
    void Reset();

    nn::Result ClearBreakPoint(uintptr_t addr, size_t size);

protected:
    DebugProcess *m_pDebugProcess;
    virtual BreakPointBase *GetBreakPoint(unsigned index) = 0;
    BreakPointBase *GetFreeBreak();

private:
};

}}

