﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace xcd {

const int SerialFlashVersion_AnalogStickValid            = 1;                                     //!< アナログスティックが有効なバージョン
const int SerialFlashVersion_DesignExt                   = 2;                                     //!< デザイン情報が追加されたバージョン

const uint32_t SerialFlashAddress_UserArea1               = 0x6000;                               //!< シリアルフラッシュのユーザ領域のオフセット
const uint32_t SerialFlashAddress_UserArea2               = 0x8000;                               //!< シリアルフラッシュのユーザ領域のオフセット

/*
 *            シリアルナンバー
 */
const uint32_t SerialFlashAddress_IdentificationCode     = SerialFlashAddress_UserArea1 + 0x00;   //!< シリアルナンバーのアドレス
const size_t   SerialFlashSize_IdentificationCode        = 0x10;                                  //!< シリアルナンバーのサイズ

/*
 *            デバイス情報
 */
const uint32_t SerialFlashAddress_DeviceType              = SerialFlashAddress_UserArea1 + 0x12; //!< デバイスの種別のアドレス
const size_t   SerialFlashSize_DeviceType                 = 0x01;                                 //!< デバイスの種別のサイズ

const uint32_t SerialFlashAddress_BoardRivision           = SerialFlashAddress_UserArea1 + 0x13; //!< ボードリビジョンのアドレス
const size_t   SerialFlashSize_BoardRivision              = 0x01;                                //!< ボードリビジョンのサイズ

const uint32_t SerialFlashAddress_BdAddr                  = SerialFlashAddress_UserArea1 + 0x14; //!< BD_ADDRのアドレス
const size_t   SerialFlashSize_BdAddr                     = 0x0a;                                //!< BD_ADDRのサイズ

const uint32_t SerialFlashAddress_FormatVersion           = SerialFlashAddress_UserArea1 + 0x1B; //!< シリアルフラッシュのフォーマットバージョンのアドレス
const size_t   SerialFlashSize_FormatVersion              = 0x01;                                //!< シリアルフラッシュのフォーマットバージョンのサイズ

/*
 *            6軸センサーのキャリブレーション
 */
const uint32_t SerialFlashAddress_SensorCal               = SerialFlashAddress_UserArea1 + 0x20; //!< 6軸センサー のCAL領域のアドレス
const size_t   SerialFlashSize_SensorCal                  = 0x18;                                //!< 6時センサー のCAL領域のサイズ

/*
 *            アナログスティックのキャリブレーション
 */
const uint32_t SerialFlashAddress_StickLeftCal            = SerialFlashAddress_UserArea1 + 0x3d; //!< 左スティックの CAL領域のアドレス
const size_t   SerialFlashSize_StickLeftCal               = 0x09;                                //!< 左スティックの CAL領域のサイズ

const uint32_t SerialFlashAddress_StickRightCal           = SerialFlashAddress_UserArea1 + 0x46; //!< 右スティックの CAL領域のアドレス
const size_t   SerialFlashSize_StickRightCal              = 0x09;                                //!< 右スティックの CAL領域のサイズ

/*
 *            デザイン情報
 */
const uint32_t SerialFlashAddress_ColorMain               = SerialFlashAddress_UserArea1 + 0x50; //!< メインの色情報のアドレス
const size_t   SerialFlashSize_ColorMain                  = 0x03;                                //!< メインの色情報のサイズ

const uint32_t SerialFlashAddress_ColorSub                = SerialFlashAddress_UserArea1 + 0x53; //!< サブの色情報のアドレス
const size_t   SerialFlashSize_ColorSub                   = 0x03;                                //!< サブの色情報のサイズ

const uint32_t SerialFlashAddress_ColorThird              = SerialFlashAddress_UserArea1 + 0x56; //!< 3色目 (左グリップ) の色情報のアドレス
const size_t   SerialFlashSize_ColorThird                 = 0x03;                                //!< 3色目 (左グリップ) サブの色情報のサイズ

const uint32_t SerialFlashAddress_ColorForth              = SerialFlashAddress_UserArea1 + 0x59; //!< 4色目 (右グリップ) の色情報のアドレス
const size_t   SerialFlashSize_ColorForth                 = 0x03;                                //!< 4色目 (右グリップ) サブの色情報のサイズ

const uint32_t SerialFlashAddress_DesignVariation         = SerialFlashAddress_UserArea1 + 0x5a; //!< デザインのバリエーションのアドレス
const size_t   SerialFlashSize_DesignVariation            = 0x01;                                //!< デザインのバリエーションのサイズ

/*
 *            モデル情報 (センサー)
 */
const uint32_t SerialFlashAddress_SensorHorizontal        = SerialFlashAddress_UserArea1 + 0x80; //!< 6軸センサーのモデル情報
const size_t   SerialFlashSize_SensorHorizontal           = 0x06;                                //!< 6軸センサーのモデル情報

/*
 *            モデル情報 (スティック)
 */
const uint32_t SerialFlashAddress_ModelStickLeft          = SerialFlashAddress_UserArea1 + 0x86; //!< 左スティックのモデル情報
const size_t   SerialFlashSize_ModelStickLeft             = 0x12;                                //!< 左スティックのモデル情報

const uint32_t SerialFlashAddress_ModelStickRight         = SerialFlashAddress_UserArea1 + 0x98; //!< 右スティックのモデル情報
const size_t   SerialFlashSize_ModelStickRight            = 0x12;                                //!< 右スティックのモデル情報

/*
 *            ユーザーキャリブレーション領域 (スティック)
 */
const uint32_t SerialFlashAddress_UserStickLeftMagicNum   = SerialFlashAddress_UserArea2 + 0x10; //!< 左スティックのユーザー CAL のマジックナンバー
const size_t   SerialFlashSize_UserStickLeftMagicNum      = 0x02;                                //!< 左スティックのユーザー CAL のマジックナンバー

const uint32_t SerialFlashAddress_UserStickLeftCal        = SerialFlashAddress_UserArea2 + 0x12; //!< 左スティックのユーザー CAL 領域のアドレス
const size_t   SerialFlashSize_UserStickLeftCal           = 0x09;                                //!< 左スティックのユーザー CAL 領域のサイズ

const uint32_t SerialFlashAddress_UserStickRightMagicNum  = SerialFlashAddress_UserArea2 + 0x1b; //!< 左スティックのユーザーキャリブレーション値のマジックナンバー
const size_t   SerialFlashSize_UserStickRightMagicNum     = 0x02;                                //!< 左スティックのユーザーキャリブレーション値のマジックナンバー

const uint32_t SerialFlashAddress_UserStickRightCal       = SerialFlashAddress_UserArea2 + 0x1d; //!< 右スティックのユーザー CAL 領域のアドレス
const size_t   SerialFlashSize_UserStickRightCal          = 0x09;                                //!< 右スティックのユーザー CAL 領域のサイズ

/*
 *            ユーザーキャリブレーション領域 (6軸センサー)
 */
const uint32_t SerialFlashAddress_UserSensorMagicNum      = SerialFlashAddress_UserArea2 + 0x26; //!< 6軸センサーのユーザーキャリブレーション値のマジックナンバー
const size_t   SerialFlashSize_UserSensorMagicNum         = 0x02;                                //!< 6軸センサーのユーザーキャリブレーション値のマジックナンバー

const uint32_t SerialFlashAddress_UserSensorCal           = SerialFlashAddress_UserArea2 + 0x28; //!< 6軸センサー のユーザー CAL領域のアドレス
const size_t   SerialFlashSize_UserSensorCal              = 0x18;                                //!< 6軸センサー のユーザー CAL領域のサイズ

/*
 * Parse を行うための各種オフセット値
 */
const uint32_t SerialFlashOffset_StickLeftMax             = 0x00;                               //!< 左スティック外周最大値のユーザー CAL 領域のオフセット
const uint32_t SerialFlashOffset_StickLeftZero            = 0x03;                               //!< 左スティック中心値のユーザー CAL 領域のオフセット
const uint32_t SerialFlashOffset_StickLeftMin             = 0x06;                               //!< 左スティック外周最小値のユーザー CAL 領域のオフセット

const uint32_t SerialFlashOffset_StickRightZero           = 0x00;                               //!< 右スティック中心値のユーザー CAL 領域のオフセット
const uint32_t SerialFlashOffset_StickRightMin            = 0x03;                               //!< 右スティック外周最小値のユーザー CAL 領域のオフセット
const uint32_t SerialFlashOffset_StickRightMax            = 0x06;                               //!< 右スティック外周最大値のユーザー CAL 領域のオフセット

const uint32_t SerialFlashOffset_Acc0g                    = 0x00;                               //!< 加速度 0G のユーザー CAL領域のオフセット
const uint32_t SerialFlashOffset_Acc1g                    = 0x06;                               //!< 加速度 1G のユーザー CAL領域のオフセット
const uint32_t SerialFlashOffset_Gyro0rpm                 = 0x0c;                               //!< ジャイロ 0rpm のユーザー CAL領域のオフセット
const uint32_t SerialFlashOffset_Gyro78rpm                = 0x12;                               //!< ジャイロ 78rpm のユーザー CAL領域のオフセット

const uint32_t SerialFlashOffset_StickNoiseAndStrokeTyp   = 0x00;                               //!< スティックの Noize, Typlical Stroke のオフセット
const Bit16    SerialFlashBit_StickXScalingRequired       = 0x0100;                             //!< X 軸のスケーリング処理が必要かどうかを示すビット (ジョイコン専用)
const uint32_t SerialFlashOffset_StickPlay                = 0x03;                               //!< スティックの 中央 / 外側不感帯のオフセット
const uint32_t SerialFlashOffset_StickMinimumStrokePos    = 0x06;                               //!< 正方向に対する保証下限ストロークのオフセット
const uint32_t SerialFlashOffset_StickMinimumStrokeNeg    = 0x09;                               //!< 負方向に対する保証下限ストロークのオフセット
const uint32_t SerialFlashOffset_StickZeroRangeMax        = 0x0c;                               //!< 原点の最大値のオフセット
const uint32_t SerialFlashOffset_StickZeroRangeMin        = 0x0f;                               //!< 原点の最小値のオフセット

}} // namespace nn::xcd
