﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Result.h>
#include <nn/nn_Macro.h>
#include <nn/xcd/xcd_DataFormat.h>
#include "xcd_CommandHandler.h"
#include "xcd_TeraBase.h"
#include "xcd_VibratorBase.h"

namespace nn { namespace xcd {

//!< OutputReportを生成するためのクラスです。Priorityの異なるOutputReportの管理を行います。
class OutputGenerator
{
private:
    CommandHandler* m_pCommand;
    TeraBase* m_pTeraBase;
    VibratorBase* m_pVibratorBase;
    PeriodicDataFormat m_DataFormat;

    uint8_t m_SampleNumber;

public:
    OutputGenerator() NN_NOEXCEPT;
    ~OutputGenerator() NN_NOEXCEPT;

    void SetPeripherals(CommandHandler* pCommand, TeraBase* pTeraBase, VibratorBase* pVibratorBase) NN_NOEXCEPT
    {
        m_pCommand = pCommand;
        m_pTeraBase = pTeraBase;
        m_pVibratorBase = pVibratorBase;
    };

    size_t GetHidReport(uint8_t* pOutValue, size_t size, bool commandOnly) NN_NOEXCEPT;

    void SetPeriodicDataFormat(PeriodicDataFormat dataFormat)
    {
        m_DataFormat = dataFormat;
    }
};

}} // namespace nn::xcd
