﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_EventTypes.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/xcd/xcd_Pairing.h>

namespace nn { namespace xcd {

//!< Bluetooth ドライバをアクティブ化する
void ActivateBluetoothDriver() NN_NOEXCEPT;

//!< Bluetooth ドライバを非アクティブ化する
void DeactivateBluetoothDriver() NN_NOEXCEPT;

//!< ペアリング情報の更新時に通知するイベントを登録する
void SetPairingUpdateEvent(::nn::os::SystemEventType* pEvent) NN_NOEXCEPT;

//!< ペアリングを開始する
void StartBluetoothButtonPairing() NN_NOEXCEPT;

//!< 本体の Bluetotoh 情報を取得する
BluetoothDeviceInfo GetHostBluetoothDeviceInfo() NN_NOEXCEPT;

//!< 登録済みの Bluetooth デバイスかどうかを評価する
bool IsRegisteredBluetoothDevice(const ::nn::bluetooth::Address address) NN_NOEXCEPT;

//!< 登録済みの Bluetooth デバイスのリストを取得する
int GetRegisteredBluetoothDevices(BluetoothDeviceInfo pOutValues[], int length) NN_NOEXCEPT;

//!< ペアリング情報を登録する
void RegisterBluetoothDevice(const BluetoothDeviceInfo& deviceInfo) NN_NOEXCEPT;

//!< ペアリング情報のリストの中での優先順位を変更する
void IncreaseBluetoothDeviceInfoOrder(const ::nn::bluetooth::Address& address) NN_NOEXCEPT;

//!< ペアリング情報から削除されないように保護する
void ProtectBluetoothDeviceInfo(const ::nn::bluetooth::Address& address, bool protect) NN_NOEXCEPT;

//!< サスペンドする
void SuspendBluetooth() NN_NOEXCEPT;

//!< レジュームする
void ResumeBluetooth() NN_NOEXCEPT;

//!< 指定されたデバイスに Bluetooth 接続を試みる
::nn::Result TriggerBluetoothConnection(const ::nn::bluetooth::Address address, nn::os::EventType* pEvent) NN_NOEXCEPT;

}} // namespace nn::xcd
