﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_Event.h>
#include <nn/xcd/xcd_Device.h>
#include <nn/bluetooth/bluetooth_Types.h>

#include "../xcd_ReportTypes.h"
#include "xcd_HidAccessor.h"
#include "xcd_IHidListener.h"
#include "xcd_UsbHidDriver-os.horizon.h"

namespace nn { namespace xcd { namespace detail{

//!< 汎用的なHidデバイスを扱うクラス
class UsbHidAccessor final : public HidAccessor
{
    NN_DISALLOW_MOVE(UsbHidAccessor);
    NN_DISALLOW_COPY(UsbHidAccessor);

private:
    //!< DeviceHandle
    DeviceHandle m_DeviceHandle;

    //!< NwcpUartDriver
    UsbHidDriver* m_pDriver;

    InputReportParserFunc m_pInputReportParserFunc;
    void* m_pInputReportParserArg;

    //!< Activateされているかどうか
    bool m_Activated;

public:
    UsbHidAccessor() NN_NOEXCEPT;
    virtual ~UsbHidAccessor() NN_NOEXCEPT NN_OVERRIDE;

    //!< Accessorを有効にする (環境依存)
    void Activate(DeviceHandle deviceHandle, UsbHidDriver* pDriver) NN_NOEXCEPT;
    //!< Accessorを無効にする
    void Deactivate() NN_NOEXCEPT;
    //!< Activagteされているかどうか
    bool IsActivated() NN_NOEXCEPT
    {
        return m_Activated;
    }

    //!< サンプリングを開始
    virtual void StartSampling(InputReportParserFunc func, void* pArg) NN_NOEXCEPT NN_OVERRIDE;

    //!< サンプリングを停止
    virtual void StopSampling() NN_NOEXCEPT NN_OVERRIDE;

    //!< OutputReportをセットする
    virtual void SetOutputReport(const uint8_t* pBuffer, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    //!< InputReportを読み出す
    virtual size_t GetInputReport(uint8_t* pOutValue, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    //!< SetReport を送信する
    virtual void SetReport(ReportType reportType, uint8_t* pBuffer, size_t size, IHidListener* pListener) NN_NOEXCEPT NN_OVERRIDE;

    //!< GetReport を送信する
    virtual void GetReport(ReportType reportType, uint8_t reportId, IHidListener* pListener) NN_NOEXCEPT NN_OVERRIDE;

    //!< 通信周期を取得する
    virtual Result GetInterval(::nn::TimeSpan* pOutInterval) NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスを切断する
    virtual void DetachDevice() NN_NOEXCEPT NN_OVERRIDE;

    DeviceHandle GetDeviceHandle() NN_NOEXCEPT
    {
        return m_DeviceHandle;
    }
};

}}} // namespace nn::xcd::detail
