﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/xcd/xcd_Result.h>
#include "xcd_TeraUpdaterStream.h"

namespace nn { namespace xcd { namespace detail {

nn::Result TeraUpdaterStream::Setup(const FirmwareImage& image) NN_NOEXCEPT
{
    NN_RESULT_DO(FirmwareUpdaterStream::Setup(image));

    // ファイルサイズは FW イメージ情報より大きいはず
    NN_RESULT_THROW_UNLESS(
        GetImageSize() > McuFirmwareImageHeaderSize,
        nn::xcd::ResultMcuInvalidFirmwareImage());

    // 最大 FW イメージサイズを超えていないか
    NN_RESULT_THROW_UNLESS(
        GetImageSize() - McuFirmwareImageHeaderSize <= McuFirmwareImageSizeMax,
        nn::xcd::ResultMcuInvalidFirmwareImage());

    // FW イメージ情報を読み込む
    size_t readBytes;
    ReadImpl(
        reinterpret_cast<uint8_t*>(&m_ImageInfo),
        &readBytes,
        McuFirmwareImageHeaderSize,
        0);
    Rewind();

    // 失敗しないはず
    NN_ABORT_UNLESS_EQUAL(readBytes, McuFirmwareImageHeaderSize);

    NN_RESULT_SUCCESS;
}

nn::Result TeraUpdaterStream::Read(
    uint8_t* pOutBuffer,
    size_t* pOutReadLength,
    size_t readLength) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
    NN_SDK_REQUIRES_NOT_NULL(pOutReadLength);

    // FW イメージ情報部分を飛ばして読む
    return ReadImpl(
        pOutBuffer,
        pOutReadLength,
        readLength,
        GetTotalReadBytes() + McuFirmwareImageHeaderSize);
}

}}} // namespace nn::xcd::detail
