﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "xcd_TeraCommon.h"
#include "xcd_TeraNfc.h"

namespace nn { namespace xcd { namespace detail {

/**
 * @brief   NfcProcessor で使用するデータ解析用の機能です。
 */
class NfcParser
{
    NN_DISALLOW_COPY(NfcParser);
    NN_DISALLOW_MOVE(NfcParser);

public:
    // タグ検知・喪失用のパーサー
    typedef nn::Result(*ParserFunctionTypeForDetect)(
        size_t*, NfcInfo*, const StatusForGetInfo&);

    // 他のイベント用のパーサー
    typedef nn::Result(*ParserFunctionTypeForGeneral)(
        size_t*, NfcInfo*, const StatusForGetInfo&, const ResponseTagData&);

public:
    /**
     * @brief   Common プロトコルの受信パケットを解析
     */
    static bool IsValidReceivedPacket(
        const uint8_t* pPacket,
        size_t packetLength) NN_NOEXCEPT;

    /**
     * @brief   タグ検知・喪失用のパーサーを取得
     */
    static ParserFunctionTypeForDetect GetParserForDetectEvent(
        InternalNfcEventType eventType) NN_NOEXCEPT;

    /**
     * @brief   タグ検知系以外のイベント用のパーサーを取得
     */
    static ParserFunctionTypeForGeneral GetParserForGeneralEvent(
        InternalNfcEventType eventType) NN_NOEXCEPT;

private:
    NfcParser();  // 静的クラスなのでインスタンス生成を禁止
};

}}}  // nn::xcd::detail
