﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_Constant.h>
#include "../xcd_CommandTypes.h"

#include "xcd_DScaleProcessor.h"

namespace {


} // namespace

namespace nn { namespace xcd { namespace detail {

DScaleProcessor::DScaleProcessor() NN_NOEXCEPT
    : m_AppletResourceUserId(::nn::applet::AppletResourceUserId::GetInvalidId())
    , m_IsWorkBufferAllocated(false)
{

}

DScaleProcessor::~DScaleProcessor() NN_NOEXCEPT
{
    // 何もしない
}

void DScaleProcessor::SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    m_AppletResourceUserId = id;
}

::nn::applet::AppletResourceUserId DScaleProcessor::GetAppletResourceUserId() NN_NOEXCEPT
{
    return m_AppletResourceUserId;
}

bool DScaleProcessor::IsWorkBufferAllocated() const NN_NOEXCEPT
{
    return m_IsWorkBufferAllocated;
}

void DScaleProcessor::Reset() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(IsWorkBufferAllocated());
}

void DScaleProcessor::InsertOneState(nn::xcd::SixAxisSensorRawParsing const (&state)[3], nn::xcd::SixAxisSensorState(&outputState)[3], uint32_t& outputStateCount, uint32_t iMode)
{
    // Translate xcd Mode to nerd Dscale Mode:
    --iMode;
    // Verification Phase
    NN_STATIC_ASSERT(nn::xcd::SensorSleepValueType_Dscale1 == nerd::DScaleProcessor::DScaleMode_DSCALE1 + 1);
    NN_STATIC_ASSERT(nn::xcd::SensorSleepValueType_Dscale1Payload6 == nerd::DScaleProcessor::DScaleMode_DSCALE2_PAYLOAD6 + 1);
    NN_STATIC_ASSERT(nn::xcd::SensorSleepValueType_Dscale1Payload12 == nerd::DScaleProcessor::DScaleMode_DSCALE3_PAYLOAD12 + 1);
    NN_STATIC_ASSERT(nn::xcd::SensorSleepValueType_Dscale2 == nerd::DScaleProcessor::DScaleMode_DSCALE4 + 1);

    nerd::DScaleProcessor::XCD_SixAxisSensorState const (&stateNerd)[3] = reinterpret_cast<nerd::DScaleProcessor::XCD_SixAxisSensorState const(&)[3]>(state);
    NN_STATIC_ASSERT(sizeof(nn::xcd::SixAxisSensorRawParsing) == sizeof(nerd::DScaleProcessor::XCD_SixAxisSensorState));
    NN_STATIC_ASSERT(sizeof(state) == sizeof(stateNerd));

    nerd::DScaleProcessor::XCD_OutputState (&outputNerd)[3] = reinterpret_cast<nerd::DScaleProcessor::XCD_OutputState (&)[3]>(outputState);
    NN_STATIC_ASSERT(sizeof(nn::xcd::SixAxisSensorState) == sizeof(nerd::DScaleProcessor::XCD_OutputState));
    NN_STATIC_ASSERT(sizeof(outputNerd) == sizeof(outputState));

    bool res = m_DScaleProcessor.InsertOneState(stateNerd, outputNerd, outputStateCount, nerd::DScaleProcessor::DScaleMode(iMode));
    // NN_SDK_ASSERT(res);
    NN_UNUSED(res);
}

//-----------------------------------------------------------------------------

}}} // namespace nn::hid::detail
